import java.io.*;
/** Application to read a file name from the keyboard and then 
  * read the file, printing the length of each line on the
  * Java console
  */
public class ReadFileBest {
   public static void main(String pars[]) throws IOException {
      // Create and store in kybd a link to the keyboard
         BufferedReader kybd= new BufferedReader(
                new InputStreamReader(System.in));
              
      // Store in fr a BufferedReader that is linked to a 
      // file named by the user
         BufferedReader fr= getReader(kybd);
             
      // Read file fr and print the length of each line
         String s= fr.readLine();
         // {inv: s is the last line read and the lengths of 
         //       lines before line s have been printed}
         while (s != null) {
           System.out.println(s.length());
           s= fr.readLine();
         }
   }
   
   /** Prompt the user for the name of a file to read (from kybd)
       and return a link to the file */
   public static BufferedReader getReader(BufferedReader kybd) 
                                          throws IOException {
      // inv: All previous user-given file names were unreadable
      while (true) {
        System.out.println("Type in the name of a file to read");
        String fName= kybd.readLine();
        try {return new BufferedReader(new FileReader(fName));
        }
        catch (FileNotFoundException e) {
          System.out.println("File or folder " + fName + 
            " does not exist or cannot be read.");
        }
      } 
   }
}
